#ifndef PARTICLE_H
#define PARTICLE_H

#include "mesh\Mesh.h"
#include "Dual.h"
#include "rt.h"
#include "utils.h"

namespace BARY
{
	class Particle
	{
	private:
		//the position of this particle
		Vec3 m_pos;
		
		//in the same order of the vertices stored in the domain
		std::vector<double> bary; 
	public:

		std::vector<Dual_Face> m_dual_faces;

		Particle()
		{ }
		Particle(Vec3 p, int num)
		{
			init_particle(p, num);
		}

		//compute the power coordinates
		void compute_power_bary(DDG::Mesh& domain, int mode, bool replug, double alpha,
			double beta, double metric_xx, double metric_yy, double metric_zz, double& max_coord, double& min_coord, bool output = false);

		//compute the weighted points for constructing the power diagram
		void compute_wps(std::vector< std::pair<Rt::Weighted_point, int> > &wpoints, DDG::Mesh& domain, bool replug,
			int mode, double metric_xx, double metric_yy, double metric_zz, double alpha, double beta);

		//compute the weight value for the given position
		double compute_weight(Vec3 p, bool replug, int mode, double alpha, double beta, double m_xx, double m_yy, double m_zz, int v_id, DDG::Mesh& domain);

		//compute the barycentric coordinates given the size ratio of the duals and primals
		void store_bary_from_dual_edges(DDG::Mesh& domain);

		//make the sum of the coordinates to be 1
		void normalize_bary();

		//initialize the particle
		void init_particle(Vec3 p, int num);

		//find the maximum/minmum value of coordinates for visualization
		void find_coord_range(double& max_coord, double& min_coord);
		
		
		//access
		Vec3 p_pos(){ return m_pos; }
		double barycoord(int i){ return bary[i]; }
	};

	
}
#endif